<?php
/**
 * This file is subject to the terms and conditions defined in file 'LICENSE', which is part of this source code
 * package. If the file is missing a copy can be found at:
 * https://gitlab.cybercoder.site/vj/policies-procedures-standards/blob/master/licensing/CYBER-LICENSE.
 */

namespace Cyber\AppHealthBundle\Controller;

use Cyber\AppHealthBundle\HealthStatusCollector;
use Cyber\AppHealthBundle\HealthStatusInterface;
use Symfony\Bundle\FrameworkBundle\Controller\AbstractController;
use Symfony\Component\HttpFoundation\JsonResponse;

class SimpleHealthController extends AbstractController
{
    /** @var HealthStatusCollector */
    private $healthCollector;

    public function __construct(HealthStatusCollector $healthCollector)
    {
        $this->healthCollector = $healthCollector;
    }

    public function getHealthAction(): JsonResponse
    {
        $reports = $this->healthCollector->collect();
        $reports = \array_map([$this, 'mapReports'], $reports);

        return new JsonResponse($reports);
    }

    /**
     * @param HealthStatusInterface $report
     *
     * @return array<mixed>
     */
    public function mapReports(HealthStatusInterface $report): array
    {
        return [
            'resource'     => $report->getResource(),
            'status'       => $report->getStatus(),
            'status_label' => HealthStatusInterface::LABELS[$report->getStatus()] ?? 'Invalid Status',
            'message'      => $report->getMessage(),
            'extra'        => $report->getExtra(),
        ];
    }
}
