<?php
/**
 * This file is subject to the terms and conditions defined in file 'LICENSE', which is part of this source code
 * package. If the file is missing a copy can be found at:
 * https://gitlab.cybercoder.site/vj/policies-procedures-standards/blob/master/licensing/CYBER-LICENSE.
 */

namespace Cyber\AppHealthBundle;

class HealthStatusCollector
{
    /**
     * @var CheckerRegistryService
     */
    private $checkerRegistry;

    /**
     * @var HealthStatusFetcher
     */
    private $fetcher;

    /**
     * @var string[]
     */
    private $urls = [];

    /**
     * HealthStatusCollector constructor.
     *
     * @param CheckerRegistryService $checkerRegistry
     */
    public function __construct(CheckerRegistryService $checkerRegistry, HealthStatusFetcher $fetcher)
    {
        $this->checkerRegistry = $checkerRegistry;
        $this->fetcher         = $fetcher;
    }

    public function addUrl(string $resource, string $url): void
    {
        $this->urls[$resource] = $url;
    }

    /**
     * @return HealthStatusInterface[]
     */
    public function collect(): array
    {
        $report = [];

        $checkers = $this->checkerRegistry->getHealthCheckers();
        foreach ($checkers as $checker) {
            $report[] = $checker->getHealthStatus();
        }

        foreach ($this->urls as $resource => $url) {
            $report[] = $this->fetcher->fetchReduced($resource, $url);
        }

        return $report;
    }
}
