<?php declare(strict_types=1);
/**
 * This file is subject to the terms and conditions defined in file 'LICENSE', which is part of this source code
 * package. If the file is missing a copy can be found at:
 * https://gitlab.cybercoder.site/vj/policies-procedures-standards/blob/master/licensing/CYBER-LICENSE.
 */

namespace Tests\Cyber\AppHealthBundle;

use Cyber\AppHealthBundle\HealthStatusInterface;
use Cyber\AppHealthBundle\HealthStatusReducer;
use Cyber\AppHealthBundle\Model\SimpleHealthStatus;
use PHPUnit\Framework\TestCase;

/**
 * @covers \Cyber\AppHealthBundle\HealthStatusReducer
 */
class HealthStatusReducerTest extends TestCase
{
    /**
     * @var HealthStatusReducer
     */
    private $instance;

    protected function setUp(): void
    {
        $this->instance = new HealthStatusReducer();
    }

    public function testReduce(): void
    {
        $statuses = [
            new SimpleHealthStatus('db', HealthStatusInterface::STATUS_HEALTHY),
            new SimpleHealthStatus('fs', HealthStatusInterface::STATUS_INFO, 'Info Msg'),
            new SimpleHealthStatus('mem', HealthStatusInterface::STATUS_DOWN, 'Err Msg'),
        ];

        $result = $this->instance->reduce('test', $statuses);
        $this->assertEquals('test', $result->getResource());
        $this->assertEquals(HealthStatusInterface::STATUS_DOWN, $result->getStatus());
        $this->assertEquals('fs => Info Msg; mem => Err Msg', $result->getMessage());
    }

    /**
     * @expectedException \InvalidArgumentException
     * @expectedExceptionMessage All statuses must be instance of HealthStatusInterface
     */
    public function testInvalidType(): void
    {
        $this->instance->reduce('test', ['']);
    }
}
