<?php
/**
 * This file is subject to the terms and conditions defined in file 'LICENSE', which is part of this source code
 * package. If the file is missing a copy can be found at:
 * https://gitlab.cybercoder.site/vj/policies-procedures-standards/blob/master/licensing/CYBER-LICENSE.
 */

namespace Cyber\AppHealthBundle\Model;

use Cyber\AppHealthBundle\HealthStatusInterface;

class SimpleHealthStatus implements HealthStatusInterface
{
    private $resource;

    private $status;

    private $message;

    private $extra;

    /**
     * SimpleHealthStatus constructor.
     *
     * @param string       $resource resource name
     * @param int          $status   health status, one of HealthStatusInterface::STATUS_* constants
     * @param string       $message  optional message with more information about status
     * @param array<mixed> $extra    extras
     */
    public function __construct(string $resource, int $status, string $message = null, array $extra = null)
    {
        $this->resource = $resource ?? 'Unknown';
        $this->status   = $status   ?? self::STATUS_UNKNOWN;
        $this->message  = $message  ?? null;
        $this->extra    = $extra    ?? null;
    }

    /**
     * @param array<mixed> $data
     *
     * @return SimpleHealthStatus
     */
    public static function fromJson(array $data): self
    {
        $status = new self(
            $data['resource'] ?? 'Unknown',
            $data['status'] ?? self::STATUS_UNKNOWN,
            $data['message'] ?? null
        );

        $status->setExtra($data['extra'] ?? null);

        return $status;
    }

    /**
     * {@inheritdoc}
     */
    public function getResource(): string
    {
        return $this->resource;
    }

    /**
     * {@inheritdoc}
     */
    public function getStatus(): int
    {
        return $this->status;
    }

    /**
     * {@inheritdoc}
     */
    public function getMessage(): ?string
    {
        return $this->message;
    }

    /**
     * @param null|array<mixed> $extra
     */
    public function setExtra(?array $extra): void
    {
        $this->extra = $extra;
    }

    /**
     * {@inheritdoc}
     */
    public function getExtra(): ?array
    {
        return $this->extra;
    }
}
