<?php
/**
 * This file is subject to the terms and conditions defined in file 'LICENSE', which is part of this source code
 * package. If the file is missing a copy can be found at:
 * https://gitlab.cybercoder.site/vj/policies-procedures-standards/blob/master/licensing/CYBER-LICENSE.
 */

namespace Tests\Cyber\AppHealthBundle;

use Cyber\AppHealthBundle\CheckerRegistryService;
use Cyber\AppHealthBundle\CyberAppHealthBundle;
use PHPUnit\Framework\TestCase;
use Symfony\Component\Config\FileLocator;
use Symfony\Component\DependencyInjection\ContainerBuilder;
use Symfony\Component\DependencyInjection\Extension\ExtensionInterface;
use Symfony\Component\DependencyInjection\Loader\YamlFileLoader;

class CyberAppHealthBundleTest extends TestCase
{
    public function testCompileBundle(): void
    {
        $container = new ContainerBuilder();
        $bundle    = new CyberAppHealthBundle();

        /** @var ExtensionInterface $extension */
        $extension = $bundle->getContainerExtension();
        $this->assertNotNull($extension);

        $container->registerExtension($extension);
        $bundle->build($container);

        $loader = new YamlFileLoader($container, new FileLocator(__DIR__ . '/Mock'));
        $loader->load('bundle_config.yml');

        $container->compile();

        $this->assertTrue($container->has('Tests\Cyber\AppHealthBundle\Mock\MockedHealthChecker'));

        /** @noinspection PhpUnhandledExceptionInspection */
        $checker = $container->get(Mock\MockedHealthChecker::class);

        /**
         * @noinspection PhpUnhandledExceptionInspection
         *
         * @var CheckerRegistryService
         */
        $registry = $container->get(CheckerRegistryService::class);

        $checkers = $registry->getHealthCheckers();
        $this->assertCount(1, $checkers);

        $this->assertSame($checker, $checkers[0]);
    }
}
