<?php
/**
 * This file is subject to the terms and conditions defined in file 'LICENSE', which is part of this source code
 * package. If the file is missing a copy can be found at:
 * https://gitlab.cybercoder.site/vj/policies-procedures-standards/blob/master/licensing/CYBER-LICENSE.
 */

namespace Tests\Cyber\AppHealthBundle\DependencyInjection;

use Cyber\AppHealthBundle\DependencyInjection\CyberAppHealthExtension;
use Cyber\AppHealthBundle\HealthStatusCollector;
use PHPUnit\Framework\TestCase;
use Symfony\Component\DependencyInjection\ContainerBuilder;

class CyberAppHealthExtensionTest extends TestCase
{
    public function testLoad(): void
    {
        $extension = new CyberAppHealthExtension();

        $container   = new ContainerBuilder();
        $fullConfigs = [
            'cyber_app_health' => [
                'external_urls' => [
                    'vantage' => 'http://domain.com/health',
                ],
            ],
        ];

        $extension->load($fullConfigs, $container);

        $methodCalls = $container->getDefinition(HealthStatusCollector::class)->getMethodCalls();
        $this->assertCount(1, $methodCalls);
        $this->assertEquals('addUrl', $methodCalls[0][0]);
        $this->assertEquals(['vantage', 'http://domain.com/health'], $methodCalls[0][1]);
    }
}
