<?php declare(strict_types=1);
/**
 * This file is subject to the terms and conditions defined in file 'LICENSE', which is part of this source code
 * package. If the file is missing a copy can be found at:
 * https://gitlab.cybercoder.site/vj/policies-procedures-standards/blob/master/licensing/CYBER-LICENSE.
 */

namespace Tests\Cyber\AppHealthBundle;

use Cyber\AppHealthBundle\CheckerRegistryService;
use Cyber\AppHealthBundle\HealthCheckerInterface;
use Cyber\AppHealthBundle\HealthStatusCollector;
use Cyber\AppHealthBundle\HealthStatusFetcher;
use Cyber\AppHealthBundle\Model\SimpleHealthStatus;
use Exception;
use PHPUnit\Framework\TestCase;

class HealthStatusCollectorTest extends TestCase
{
    /**
     * @var CheckerRegistryService|\PHPUnit\Framework\MockObject\MockObject
     */
    private $registry;

    /**
     * @var HealthStatusFetcher|\PHPUnit\Framework\MockObject\MockObject
     */
    private $fetcher;

    private HealthStatusCollector $collector;

    public function testCollectException(): void
    {
        $errorText = 'some abstract error';

        $checker = $this->getMockBuilder(HealthCheckerInterface::class)
            ->addMethods(['getResourceName'])
            ->getMockForAbstractClass();

        $checker->method('getResourceName')
            ->willReturn('Mock Report');

        $checker->method('getHealthStatus')
            ->willThrowException(new Exception($errorText));

        $this->registry->expects(self::any())
            ->method('getHealthCheckers')
            ->willReturn([$checker]);

        $reports = $this->collector->collect();

        $this->assertCount(1, $reports);

        /** @var SimpleHealthStatus $report */
        $report = $reports[0];

        $this->assertEquals('Failed to retrieve health data.', $report->getMessage());
        $extras = $report->getExtra();
        $this->assertNotNull($extras);
        $this->assertEquals($errorText, $extras[0]);
    }

    protected function setUp(): void
    {
        $this->registry = $this->getMockBuilder(CheckerRegistryService::class)->getMock();
        $this->fetcher  = $this->getMockBuilder(HealthStatusFetcher::class)->disableOriginalConstructor()->getMock();

        $this->collector = new HealthStatusCollector($this->registry, $this->fetcher);
    }
}
