<?php
/**
 * This file is subject to the terms and conditions defined in file 'LICENSE', which is part of this source code
 * package. If the file is missing a copy can be found at:
 * https://gitlab.cybercoder.site/vj/policies-procedures-standards/blob/master/licensing/CYBER-LICENSE.
 */

namespace Cyber\AppHealthBundle\DependencyInjection\Compiler;

use Cyber\AppHealthBundle\CheckerRegistryService;
use Symfony\Component\DependencyInjection\Compiler\CompilerPassInterface;
use Symfony\Component\DependencyInjection\ContainerBuilder;
use Symfony\Component\DependencyInjection\Reference;

class CheckerCollectorPass implements CompilerPassInterface
{
    public function process(ContainerBuilder $container): void
    {
        $taggedServices = $container->findTaggedServiceIds('cyber.health.checker');
        $definition     = $container->getDefinition(CheckerRegistryService::class);
        foreach (\array_keys($taggedServices) as $id) {
            $definition->addMethodCall('addHealthChecker', [new Reference($id)]);
        }
    }
}
