<?php
/**
 * This file is subject to the terms and conditions defined in file 'LICENSE', which is part of this source code
 * package. If the file is missing a copy can be found at:
 * https://gitlab.cybercoder.site/vj/policies-procedures-standards/blob/master/licensing/CYBER-LICENSE.
 */

namespace Cyber\AuditBundle\Form;

use Cyber\AuditBundle\Entity\Criteria\EventCriteria;
use Cyber\AuditBundle\Entity\Event;
use Symfony\Component\Form\AbstractType;
use Symfony\Component\Form\Extension\Core\Type\ChoiceType;
use Symfony\Component\Form\Extension\Core\Type\CollectionType;
use Symfony\Component\Form\Extension\Core\Type\DateType;
use Symfony\Component\Form\FormBuilderInterface;
use Symfony\Component\OptionsResolver\OptionsResolver;

class EventCriteriaType extends AbstractType
{
    /**
     * {@inheritdoc}
     */
    public function buildForm(FormBuilderInterface $builder, array $options): void
    {
        $actions = \array_flip(Event::TYPE_NAMES);

        $builder
            ->add('entities', CollectionType::class, [
                'allow_add'   => true,
                'entry_type'  => EntityCriteriaType::class,
            ])
            ->add('dateFrom', DateType::class, [
                'format'   => 'yyyy-MM-dd',
                'required' => false,
                'widget'   => $options['date_widget'],
            ])
            ->add('dateTo', DateType::class, [
                'format'   => 'yyyy-MM-dd',
                'required' => false,
                'widget'   => $options['date_widget'],
            ])
            ->add('actions', ChoiceType::class, [
                'multiple'    => true,
                'choices'     => $actions,
                'required'    => false,
            ]);
    }

    public function configureOptions(OptionsResolver $resolver): void
    {
        $resolver->setDefaults([
            'data_class'  => EventCriteria::class,
            'date_widget' => 'single_text',
        ]);
    }
}
