<?php
/**
 * This file is subject to the terms and conditions defined in file 'LICENSE', which is part of this source code
 * package. If the file is missing a copy can be found at:
 * https://gitlab.cybercoder.site/vj/policies-procedures-standards/blob/master/licensing/CYBER-LICENSE.
 */

namespace Cyber\AuditBundle\Annotation;

use Doctrine\Common\Annotations\Annotation;

/**
 * The value of the property/method to which this annotation is applied will be used to populate entity
 * description in the audit.
 *
 * When applying to property keep in mind that if object is a Doctrine proxy, that does not have that property
 * initialized, the Audit will NOT initialize it for you, resulting in null values logged.
 *
 * @Annotation
 * @Target({"PROPERTY", "METHOD"})
 */
class Describe extends Annotation
{
}
