<?php
/**
 * This file is subject to the terms and conditions defined in file 'LICENSE', which is part of this source code
 * package. If the file is missing a copy can be found at:
 * https://gitlab.cybercoder.site/vj/policies-procedures-standards/blob/master/licensing/CYBER-LICENSE.
 */

namespace Cyber\AuditBundle\Annotation;

use Doctrine\Common\Annotations\Annotation;

/**
 * If inclusion policy is 'NONE' you must apply this annotation to each field you wish to track.
 *
 * @Annotation
 * @Target("PROPERTY")
 */
class Track extends Annotation
{
    /**
     * If this property stores values that are non-user friendly constants/ids/statuses you may provide fully qualified
     * path to an array which contains user friendly descriptions of these values, in order to create a more user
     * friendly audit.
     *
     * Array must have keys matching the values stored in this field, and values of those keys will be used as user
     * friendly value.
     *
     * @var string
     */
    public $userValueList;
}
