<?php
/**
 * This file is subject to the terms and conditions defined in file 'LICENSE', which is part of this source code
 * package. If the file is missing a copy can be found at:
 * https://gitlab.cybercoder.site/vj/policies-procedures-standards/blob/master/licensing/CYBER-LICENSE.
 */

namespace Cyber\AuditBundle;

class AuditEvents
{
    /**
     * Trigger to forcefully flush the audit event queue to the db.
     *
     * By default the flush occurs automatically on kernel shutdown/console terminate
     *
     * Useful for testing as there are now shutdown events typically executed.
     *
     * The event object passed with this event is not used.
     *
     * @var string
     */
    const FLUSH_QUEUE = 'cyber.audit.flush';
}
