<?php
/**
 * This file is subject to the terms and conditions defined in file 'LICENSE', which is part of this source code
 * package. If the file is missing a copy can be found at:
 * https://gitlab.cybercoder.site/vj/policies-procedures-standards/blob/master/licensing/CYBER-LICENSE.
 */

namespace Cyber\AuditBundle\DependencyInjection;

use Symfony\Component\Config\Definition\Builder\ArrayNodeDefinition;
use Symfony\Component\Config\Definition\Builder\TreeBuilder;
use Symfony\Component\Config\Definition\ConfigurationInterface;

/**
 * This is the class that validates and merges configuration from your app/config files.
 *
 * To learn more see {@link http://symfony.com/doc/current/cookbook/bundles/configuration.html}
 */
class Configuration implements ConfigurationInterface
{
    /**
     * @inheritdoc
     */
    public function getConfigTreeBuilder(): TreeBuilder
    {
        $treeBuilder = new TreeBuilder('cyber_audit');

        /** @var ArrayNodeDefinition $rootNode */
        $rootNode = $treeBuilder->getRootNode();

        $rootNode->children()
            ->arrayNode('entity')->isRequired()
                ->children()
                    ->scalarNode('change')->isRequired()->cannotBeEmpty()->info('Class name of the Change entity')->end()
                    ->scalarNode('event')->isRequired()->cannotBeEmpty()->info('Class name of the Event entity')->end()
                    ->scalarNode('map')->isRequired()->cannotBeEmpty()->info('Class name of the EventMap entity')->end()
                ->end()
            ->end();

        return $treeBuilder;
    }
}
