<?php
/**
 * This file is subject to the terms and conditions defined in file 'LICENSE', which is part of this source code
 * package. If the file is missing a copy can be found at:
 * https://gitlab.cybercoder.site/vj/policies-procedures-standards/blob/master/licensing/CYBER-LICENSE.
 */

namespace Cyber\AuditBundle\Entity;

use Doctrine\ORM\Mapping as ORM;

/**
 * @ORM\Embeddable
 */
class ChangeValue
{
    /**
     * @var null|callable|callable[]|string|string[]
     *
     * @ORM\Column(type="text", nullable=true)
     */
    private $rawValue;

    /**
     * @var null|callable|callable[]|string|string[]
     *
     * @ORM\Column(type="text", nullable=true)
     */
    private $userValue;

    /**
     * ChangeValue constructor.
     *
     * @param null|callable|callable[]|string|string[] $rawValue
     * @param null|callable|callable[]|string|string[] $userValue
     */
    public function __construct($rawValue = null, $userValue = null)
    {
        $this->rawValue  = $rawValue;
        $this->userValue = $userValue;
    }

    /**
     * @return null|callable|callable[]|string|string[]
     */
    public function getRawValue()
    {
        return $this->rawValue;
    }

    /**
     * @param null|string $rawValue
     */
    public function setRawValue(?string $rawValue): void
    {
        $this->rawValue = $rawValue;
    }

    /**
     * @return null|callable|callable[]|string|string[]
     */
    public function getUserValue()
    {
        return $this->userValue;
    }

    /**
     * @param null|string $userValue
     */
    public function setUserValue(?string $userValue): void
    {
        $this->userValue = $userValue;
    }
}
