<?php
/**
 * This file is subject to the terms and conditions defined in file 'LICENSE', which is part of this source code
 * package. If the file is missing a copy can be found at:
 * https://gitlab.cybercoder.site/vj/policies-procedures-standards/blob/master/licensing/CYBER-LICENSE.
 */

namespace Cyber\AuditBundle\Annotation;

use Attribute;
use Doctrine\Common\Annotations\Annotation\NamedArgumentConstructor;

/**
 * @Annotation
 *
 * @NamedArgumentConstructor
 *
 * @Target("CLASS")
 */
#[Attribute(Attribute::TARGET_CLASS)]
class Apply implements Annotation
{
    const INCLUDE_ALL = 'ALL';

    const INCLUDE_NONE = 'NONE';

    /**
     * A user friendly name of the entity.
     *
     * If not provided exact entity class name will be used.
     *
     * @var null|string
     */
    public $displayName;

    /**
     * Decides if all fields should be included in audit.
     *
     * @var string default 'ALL'
     *
     * @Enum({"ALL", "NONE"})
     */
    public $inclusionCriteria = 'ALL';

    public function __construct(string $inclusionCriteria = 'ALL', ?string $displayName = null)
    {
        $this->displayName       = $displayName;
        $this->inclusionCriteria = $inclusionCriteria;
    }
}
