<?php
/**
 * This file is subject to the terms and conditions defined in file 'LICENSE', which is part of this source code
 * package. If the file is missing a copy can be found at:
 * https://gitlab.cybercoder.site/vj/policies-procedures-standards/blob/master/licensing/CYBER-LICENSE.
 */

namespace Cyber\AuditBundle\Entity;

use Doctrine\ORM\Mapping as ORM;

/**
 * @ORM\MappedSuperclass
 */
#[ORM\MappedSuperclass]
class EventMap
{
    /**
     * @var Event
     */
    protected $event;

    /**
     * @var string
     *
     * @ORM\Column(type="string", length=255, nullable=false)
     */
    #[ORM\Column(type: 'string', length: 255, nullable: false)]
    protected $entityClass;

    /**
     * @var callable|string
     *
     * @ORM\Column(type="integer", nullable=false)
     */
    #[ORM\Column(type: 'integer', nullable: false)]
    protected $entityId;

    /**
     * @return string
     */
    public function getEntityClass(): string
    {
        return $this->entityClass;
    }

    /**
     * @param string $entityClass
     *
     * @return EventMap
     */
    public function setEntityClass(string $entityClass): self
    {
        $this->entityClass = $entityClass;

        return $this;
    }

    /**
     * @return callable|string
     */
    public function getEntityId()
    {
        return $this->entityId;
    }

    /**
     * @param callable|string $entityId
     *
     * @return EventMap
     */
    public function setEntityId($entityId): self
    {
        $this->entityId = $entityId;

        return $this;
    }

    /**
     * @return Event
     */
    public function getEvent(): Event
    {
        return $this->event;
    }

    /**
     * @param Event $event
     *
     * @return EventMap
     */
    public function setEvent(Event $event): self
    {
        $this->event = $event;

        return $this;
    }
}
