<?php
/**
 * This file is subject to the terms and conditions defined in file 'LICENSE', which is part of this source code
 * package. If the file is missing a copy can be found at:
 * https://gitlab.cybercoder.site/vj/policies-procedures-standards/blob/master/licensing/CYBER-LICENSE.
 */

namespace Cyber\AuditBundle\Service;

use Cyber\AuditBundle\Entity\Change;
use Cyber\AuditBundle\Entity\Event;
use Cyber\AuditBundle\Entity\EventMap;

/**
 * @internal
 */
class EntityFactory
{
    private $changeClass;

    private $eventClass;

    private $mapClass;

    /**
     * EntityFactory constructor.
     *
     * @param string $changeClass
     * @param string $eventClass
     * @param string $mapClass
     */
    public function __construct(string $changeClass, string $eventClass, string $mapClass)
    {
        $this->changeClass = $changeClass;
        $this->eventClass  = $eventClass;
        $this->mapClass    = $mapClass;
    }

    /**
     * @return Event
     */
    public function createEvent(): Event
    {
        return new $this->eventClass();
    }

    /**
     * @return Change
     */
    public function createChange(): Change
    {
        return new $this->changeClass();
    }

    /**
     * @return EventMap
     */
    public function createMap(): EventMap
    {
        return new $this->mapClass();
    }

    /**
     * @return mixed
     */
    public function getChangeClass()
    {
        return $this->changeClass;
    }

    /**
     * @return mixed
     */
    public function getEventClass()
    {
        return $this->eventClass;
    }

    /**
     * @return mixed
     */
    public function getMapClass()
    {
        return $this->mapClass;
    }
}
