<?php
/**
 * This file is subject to the terms and conditions defined in file 'LICENSE', which is part of this source code
 * package. If the file is missing a copy can be found at:
 * https://gitlab.cybercoder.site/vj/policies-procedures-standards/blob/master/licensing/CYBER-LICENSE.
 */

namespace Cyber\AuditBundle\Describer;

class PropertyDescriber implements Describer
{
    /** @var \ReflectionProperty */
    private $reflectionProp;

    public function __construct(\ReflectionProperty $reflectionProp)
    {
        $this->reflectionProp = $reflectionProp;
        $this->reflectionProp->setAccessible(true);
    }

    public function describe($object): ?string
    {
        return (string) $this->reflectionProp->getValue($object);
    }
}
