<?php
/**
 * This file is subject to the terms and conditions defined in file 'LICENSE', which is part of this source code
 * package. If the file is missing a copy can be found at:
 * https://gitlab.cybercoder.site/vj/policies-procedures-standards/blob/master/licensing/CYBER-LICENSE.
 */

namespace Tests\Cyber\AuditBundle\EventListener;

use Cyber\AuditBundle\AuditBuilder;
use Cyber\AuditBundle\Entity\Event;
use Cyber\AuditBundle\EventListener\AuditKernelSubscriber;
use Cyber\AuditBundle\Service\AuditManager;
use Cyber\AuditBundle\Service\AuditQueue;
use Cyber\AuditBundle\Service\EntityFactory;
use Doctrine\Common\Annotations\Reader;
use Doctrine\Persistence\ManagerRegistry;
use Doctrine\Persistence\ObjectManager;
use PHPUnit\Framework\MockObject\MockObject;
use PHPUnit\Framework\TestCase;

class AuditKernelSubscriberTest extends TestCase
{
    /**
     * Should check the work disabled entity.
     */
    public function testShouldtCheckTheWorkDisabledEntity(): void
    {
        /** @var AuditBuilder<mixed>|MockObject $builder */
        $builder = $this->getMockBuilder(AuditBuilder::class)
            ->disableOriginalConstructor()
            ->getMock();

        $queue = new AuditQueue();

        $queue->enqueue($builder);

        /** @var EntityFactory<mixed>|MockObject $entityFactory */
        $entityFactory = $this->getMockBuilder(EntityFactory::class)
            ->disableOriginalConstructor()
            ->getMock();

        /** @var ManagerRegistry|MockObject $doctrine */
        $doctrine = $this->getMockBuilder(ManagerRegistry::class)
            ->getMock();

        /** @var MockObject|Reader $reader */
        $reader = $this->getMockBuilder(Reader::class)
            ->disableOriginalConstructor()
            ->getMock();

        /** @var MockObject|ObjectManager $objectManager */
        $objectManager = $this->getMockBuilder(ObjectManager::class)
            ->getMock();

        /** @var Event<mixed>|MockObject $event */
        $event = $this->getMockBuilder(Event::class)
            ->disableOriginalConstructor()
            ->getMock();

        $builder->method('getEvent')->willReturn($event);
        $doctrine->method('getManagerForClass')->willReturn($objectManager);
        $builder->method('isValid')->willReturn(true);
        $builder->method('getResolvedEvent')->willReturn($event);
        $builder->method('getEntityClass')->willReturn('test');
        $objectManager->expects($this->never())->method('persist');

        $manager = new AuditManager($entityFactory, $doctrine, $reader, $queue);
        $manager->disableForEntity('test');
        $auditKernel = new AuditKernelSubscriber($doctrine, $queue, $manager);

        $auditKernel->storeAudits();
    }
}
