<?php
/**
 * This file is subject to the terms and conditions defined in file 'LICENSE', which is part of this source code
 * package. If the file is missing a copy can be found at:
 * https://gitlab.cybercoder.site/vj/policies-procedures-standards/blob/master/licensing/CYBER-LICENSE.
 */

namespace Tests\Cyber\AuditBundle;

use Cyber\AuditBundle\AuditBuilder;
use Cyber\AuditBundle\AuditEventMapper;
use Cyber\AuditBundle\Service\AuditManager;
use Doctrine\ORM\EntityManagerInterface;
use Doctrine\Persistence\Mapping\ClassMetadata;
use PHPUnit\Framework\Constraint\IsInstanceOf;
use PHPUnit\Framework\MockObject\MockObject;
use PHPUnit\Framework\TestCase;
use ReflectionClass;
use stdClass;

class AuditEventMapperTest extends TestCase
{
    /** @var AuditEventMapper */
    private $eventMapper;

    /** @var AuditBuilder<mixed>|MockObject */
    private $builder;

    /** @var EntityManagerInterface|MockObject */
    private $em;

    /** @var AuditManager<mixed>|MockObject */
    private $auditManager;

    /**
     * @inheritdoc
     */
    protected function setUp(): void
    {
        $this->builder      = $this->getMockBuilder(AuditBuilder::class)->disableOriginalConstructor()->getMock();
        $this->em           = $this->getMockBuilder(EntityManagerInterface::class)->getMock();
        $this->auditManager = $this->getMockBuilder(AuditManager::class)->disableOriginalConstructor()->getMock();

        $this->eventMapper = new AuditEventMapper($this->em, $this->auditManager);
    }

    public function testMapSelf(): void
    {
        $stdMetadata = $this->getMockBuilder(ClassMetadata::class)->getMock();
        $ownerMeta   = $this->getMockBuilder(ClassMetadata::class)->getMock();

        $this->em->expects($this->any())
            ->method('getClassMetadata')
            ->willReturnCallback(function ($classname) use ($stdMetadata, $ownerMeta) {
                switch ($classname) {
                    case 'stdClass':
                        return $stdMetadata;
                    case '':
                        return $ownerMeta;
                }
            });

        $stdMetadata->expects($this->any())
            ->method('getReflectionClass')
            ->willReturn(new ReflectionClass('stdClass'));

        $this->builder->expects($this->once())
            ->method('mappedTo')
            ->with('stdClass', new IsInstanceOf('Closure'));
        $this->eventMapper->buildEventMap($this->builder, new stdClass());
    }
}
