<?php
/**
 * This file is subject to the terms and conditions defined in file 'LICENSE', which is part of this source code
 * package. If the file is missing a copy can be found at:
 * https://gitlab.cybercoder.site/vj/policies-procedures-standards/blob/master/licensing/CYBER-LICENSE.
 */

namespace Cyber\AuditBundle\DependencyInjection;

use Cyber\AuditBundle\Service\AttributeReader;
use Cyber\AuditBundle\Service\AuditManager;
use Symfony\Component\Config\FileLocator;
use Symfony\Component\DependencyInjection\ContainerBuilder;
use Symfony\Component\DependencyInjection\Loader;
use Symfony\Component\DependencyInjection\Reference;
use Symfony\Component\HttpKernel\DependencyInjection\Extension;

/**
 * This is the class that loads and manages your bundle configuration.
 *
 * @see http://symfony.com/doc/current/cookbook/bundles/extension.html
 */
class CyberAuditExtension extends Extension
{
    /**
     * @inheritdoc
     */
    public function load(array $configs, ContainerBuilder $container): void
    {
        $loader = new Loader\YamlFileLoader($container, new FileLocator(__DIR__ . '/../Resources/config'));
        $loader->load('services.yml');

        $configuration = new Configuration();
        $config        = $this->processConfiguration($configuration, $configs);

        foreach ($config['entity'] as $key => $value) {
            $container->setParameter($this->getAlias() . '.entity.' . $key, $value);
        }

        if ('attribute' === $config['metadata_driver']) {
            $container->getDefinition(AuditManager::class)
                ->setArgument('$reader', new Reference(AttributeReader::class));
        }

        $factory = $config['entity']['factory'];
        if ($factory) {
            if (0 === \mb_strpos($factory, '@')) {
                $container->setAlias('cyber.audit.entity_factory.service', \mb_substr($factory, 1));

                return;
            }
            $container->getDefinition('cyber.audit.entity_factory.service')
                ->setClass($factory);
        }
    }
}
