<?php
/**
 * This file is subject to the terms and conditions defined in file 'LICENSE', which is part of this source code
 * package. If the file is missing a copy can be found at:
 * https://gitlab.cybercoder.site/vj/policies-procedures-standards/blob/master/licensing/CYBER-LICENSE.
 */

namespace Cyber\AuditBundle\Entity;

use Doctrine\ORM\Mapping as ORM;

/**
 * @ORM\MappedSuperclass
 */
#[ORM\MappedSuperclass]
class Change
{
    const NULL_CHANGE = '(null)';

    /**
     * @var Event<mixed>
     */
    protected $event;

    /**
     * @var string
     *
     * @ORM\Column(type="string", length=255, nullable=false)
     */
    #[ORM\Column(type: 'string', length: 255, nullable: false)]
    protected $field;

    /**
     * @var ChangeValue
     *
     * @ORM\Embedded(class="Cyber\AuditBundle\Entity\ChangeValue", columnPrefix="ach_old_")
     */
    #[ORM\Embedded(class: 'Cyber\\AuditBundle\\Entity\\ChangeValue', columnPrefix: 'ach_old_')]
    protected $oldValue;

    /**
     * @var ChangeValue
     *
     * @ORM\Embedded(class="Cyber\AuditBundle\Entity\ChangeValue", columnPrefix="ach_new_")
     */
    #[ORM\Embedded(class: 'Cyber\\AuditBundle\\Entity\\ChangeValue', columnPrefix: 'ach_new_')]
    protected $newValue;

    /**
     * Change constructor.
     */
    public function __construct()
    {
        $this->oldValue = new ChangeValue();
        $this->newValue = new ChangeValue();
    }

    /**
     * @return string
     */
    public function getField(): string
    {
        return $this->field;
    }

    /**
     * @param string $field
     *
     * @return $this
     */
    public function setField(string $field): self
    {
        $this->field = $field;

        return $this;
    }

    /**
     * @return ChangeValue
     */
    public function getOldValue(): ChangeValue
    {
        return $this->oldValue;
    }

    /**
     * @param ChangeValue $oldValue
     *
     * @return $this
     */
    public function setOldValue(ChangeValue $oldValue): self
    {
        $this->oldValue = $oldValue;

        return $this;
    }

    /**
     * @return ChangeValue
     */
    public function getNewValue(): ChangeValue
    {
        return $this->newValue;
    }

    /**
     * @param ChangeValue $newValue
     *
     * @return $this
     */
    public function setNewValue(ChangeValue $newValue): self
    {
        $this->newValue = $newValue;

        return $this;
    }

    /**
     * @return Event<mixed>
     */
    public function getEvent(): Event
    {
        return $this->event;
    }

    /**
     * @param Event<mixed> $event
     *
     * @return $this
     */
    public function setEvent(Event $event): self
    {
        $this->event = $event;

        return $this;
    }
}
