<?php
/**
 * This file is subject to the terms and conditions defined in file 'LICENSE', which is part of this source code
 * package. If the file is missing a copy can be found at:
 * https://gitlab.cybercoder.site/vj/policies-procedures-standards/blob/master/licensing/CYBER-LICENSE.
 */

namespace Cyber\AuditBundle\Describer;

class ToStringDescriber implements Describer
{
    /**
     * @inheritdoc
     */
    public function describe($object): ?string
    {
        if (\method_exists($object, '__toString')) {
            return (string) $object;
        }

        return null;
    }
}
