<?php
/**
 * This file is subject to the terms and conditions defined in file 'LICENSE', which is part of this source code
 * package. If the file is missing a copy can be found at:
 * https://gitlab.cybercoder.site/vj/policies-procedures-standards/blob/master/licensing/CYBER-LICENSE.
 */

namespace Cyber\AuditBundle\Entity;

use Doctrine\DBAL\Types\Types;
use Doctrine\ORM\Mapping as ORM;

/**
 * @template T
 * @template IdType
 *
 * @phpstan-type CallableId callable(): IdType
 */
#[ORM\MappedSuperclass]
class EventMap
{
    /**
     * @var string
     */
    #[ORM\Column(type: Types::STRING, length: 255, nullable: false)]
    protected string $entityClass = '';

    /**
     * @var CallableId|IdType
     */
    protected $entityId;

    /**
     * @param Event<T, IdType> $event
     */
    public function __construct(protected Event $event)
    {
    }

    /**
     * @return string
     */
    public function getEntityClass(): string
    {
        return $this->entityClass;
    }

    /**
     * @param class-string $entityClass
     *
     * @return $this
     */
    public function setEntityClass(string $entityClass): self
    {
        $this->entityClass = $entityClass;

        return $this;
    }

    /**
     * @return CallableId|IdType
     */
    public function getEntityId()
    {
        return $this->entityId;
    }

    /**
     * @param non-empty-array<IdType> $entityId
     *
     * @return $this
     */
    public function setEntityId($entityId): self
    {
        $this->entityId = $entityId[0];

        return $this;
    }

    /**
     * @return Event<T, IdType>
     */
    public function getEvent(): Event
    {
        return $this->event;
    }
}
