<?php declare(strict_types=1);
/**
 * This file is subject to the terms and conditions defined in file 'LICENSE', which is part of this source code
 * package. If the file is missing a copy can be found at:
 * https://gitlab.cybercoder.site/vj/policies-procedures-standards/blob/master/licensing/CYBER-LICENSE.
 */

namespace Tests\Cyber\AuditBundle\Service;

use Cyber\AuditBundle\Annotation\Apply;
use Cyber\AuditBundle\Annotation\Describe;
use Cyber\AuditBundle\Service\AttributeReader;
use PHPUnit\Framework\TestCase;
use ReflectionClass;

#[Apply(inclusionCriteria: 'NONE', displayName: 'test')]
class AttributeReaderTest extends TestCase
{
    #[Describe]
    public function testReader(): void
    {
        if (PHP_VERSION_ID < 80000) {
            $this->markTestSkipped('Only PHP >= 8');
        }
        $instance = new AttributeReader();

        $ref = new ReflectionClass(self::class);

        /** @var null|Apply $apply */
        $apply = $instance->getClassAttribute($ref, Apply::class);

        $this->assertNotNull($apply);
        $this->assertEquals('NONE', $apply->inclusionCriteria);
        $this->assertEquals('test', $apply->displayName);

        $describe = $instance->getMethodAttribute($ref->getMethod('testReader'), Describe::class);
        $this->assertInstanceOf(Describe::class, $describe);
    }
}
