<?php

/**
 * This file is subject to the terms and conditions defined in file 'LICENSE', which is part of this source code
 * package. If the file is missing a copy can be found at:
 * https://gitlab.cybercoder.site/vj/policies-procedures-standards/blob/master/licensing/CYBER-LICENSE.
 */

namespace Cyber\AuditBundle\Entity\Criteria;

use DateTime;

class EventCriteria
{
    /**
     * To limit data to specific entities add them to this array.
     *
     * @var EntityCriteria[]
     */
    public $entities = [];

    /**
     * @var null|DateTime
     */
    public $dateFrom;

    /**
     * @var null|DateTime
     */
    public $dateTo;

    /**
     * @var int[]
     */
    public $actions = [];

    public function addEntity(string $class, ?string $id = null): self
    {
        $entity              = new EntityCriteria();
        $entity->entityClass = $class;
        $entity->entityId    = $id;
        $this->entities[]    = $entity;

        return $this;
    }
}
