<?php

/**
 * This file is subject to the terms and conditions defined in file 'LICENSE', which is part of this source code
 * package. If the file is missing a copy can be found at:
 * https://gitlab.cybercoder.site/vj/policies-procedures-standards/blob/master/licensing/CYBER-LICENSE.
 */

namespace Tests\Cyber\AuditBundle\EventListener;

use Cyber\AuditBundle\AuditBuilder;
use Cyber\AuditBundle\Entity\Event;
use Cyber\AuditBundle\EventListener\AuditKernelListener;
use Cyber\AuditBundle\Service\AttributeReader;
use Cyber\AuditBundle\Service\AuditManager;
use Cyber\AuditBundle\Service\AuditQueue;
use Cyber\AuditBundle\Service\EntityFactory;
use Doctrine\Persistence\ManagerRegistry;
use Doctrine\Persistence\ObjectManager;
use PHPUnit\Framework\MockObject\MockObject;
use PHPUnit\Framework\TestCase;

/**
 * @internal
 *
 * @coversNothing
 */
class AuditKernelSubscriberTest extends TestCase
{
    /**
     * Should check the work disabled entity.
     */
    public function testShouldtCheckTheWorkDisabledEntity(): void
    {
        /** @var AuditBuilder<mixed, mixed>|MockObject $builder */
        $builder = $this->getMockBuilder(AuditBuilder::class)
            ->disableOriginalConstructor()
            ->getMock();

        $queue = new AuditQueue();

        $queue->enqueue($builder);

        /** @var EntityFactory<mixed, mixed>|MockObject $entityFactory */
        $entityFactory = $this->getMockBuilder(EntityFactory::class)
            ->disableOriginalConstructor()
            ->getMock();

        /** @var ManagerRegistry|MockObject $doctrine */
        $doctrine = $this->getMockBuilder(ManagerRegistry::class)
            ->getMock();

        $reader = new AttributeReader();

        /** @var MockObject|ObjectManager $objectManager */
        $objectManager = $this->getMockBuilder(ObjectManager::class)
            ->getMock();

        /** @var Event<mixed, mixed>|MockObject $event */
        $event = $this->getMockBuilder(Event::class)
            ->disableOriginalConstructor()
            ->getMock();

        $builder->method('getEvent')->willReturn($event);
        $doctrine->method('getManagerForClass')->willReturn($objectManager);
        $builder->method('isValid')->willReturn(true);
        $builder->method('getEntityClass')->willReturn('test');
        $objectManager->expects(static::never())->method('persist');

        $manager = new AuditManager($entityFactory, $doctrine, $reader, $queue);
        $manager->disableForEntity('test');
        $auditKernel = new AuditKernelListener($doctrine, $queue, $manager);

        $auditKernel->storeAudits();
    }
}
