<?php

/**
 * This file is subject to the terms and conditions defined in file 'LICENSE', which is part of this source code
 * package. If the file is missing a copy can be found at:
 * https://gitlab.cybercoder.site/vj/policies-procedures-standards/blob/master/licensing/CYBER-LICENSE.
 */

namespace Cyber\AuditBundle\Service;

use SplDoublyLinkedList;
use SplQueue;

/**
 * @internal
 *
 * @extends \SplQueue<\Cyber\AuditBundle\AuditBuilder>
 */
class AuditQueue extends SplQueue
{
    /**
     * @inheritDoc
     */
    public function __construct()
    {
        // remove items from queue as we iterate through it using foreach
        parent::setIteratorMode(SplDoublyLinkedList::IT_MODE_DELETE);
    }
}
