<?php

/**
 * This file is subject to the terms and conditions defined in file 'LICENSE', which is part of this source code
 * package. If the file is missing a copy can be found at:
 * https://gitlab.cybercoder.site/vj/policies-procedures-standards/blob/master/licensing/CYBER-LICENSE.
 */

namespace Cyber\AuditBundle\Describer;

use ReflectionProperty;
use Stringable;

class PropertyDescriber implements Describer
{
    /** @var ReflectionProperty */
    private $reflectionProp;

    public function __construct(ReflectionProperty $reflectionProp)
    {
        $this->reflectionProp = $reflectionProp;
        $this->reflectionProp->setAccessible(true);
    }

    public function describe(object $object): ?string
    {
        if (!$this->reflectionProp->isInitialized($object)) {
            // do not try to get value of uninitialized properties
            return null;
        }
        /** @var scalar|Stringable $description */
        $description = $this->reflectionProp->getValue($object);

        return (string) $description;
    }
}
