<?php

/**
 * This file is subject to the terms and conditions defined in file 'LICENSE', which is part of this source code
 * package. If the file is missing a copy can be found at:
 * https://gitlab.cybercoder.site/vj/policies-procedures-standards/blob/master/licensing/CYBER-LICENSE.
 */

namespace Cyber\AuditBundle\Entity;

use Doctrine\DBAL\Types\Types;
use Doctrine\ORM\Mapping as ORM;

#[ORM\MappedSuperclass]
class Change
{
    public const NULL_CHANGE = '(null)';

    /**
     * @var Event<mixed, mixed>
     */
    protected Event $event;

    #[ORM\Column(type: Types::STRING, length: 255, nullable: false)]
    protected string $field = '';

    #[ORM\Embedded(class: ChangeValue::class, columnPrefix: 'ach_old_')]
    protected ChangeValue $oldValue;

    #[ORM\Embedded(class: ChangeValue::class, columnPrefix: 'ach_new_')]
    protected ChangeValue $newValue;

    public function __construct()
    {
        $this->oldValue = new ChangeValue();
        $this->newValue = new ChangeValue();
    }

    public function getField(): string
    {
        return $this->field;
    }

    /**
     * @return $this
     */
    public function setField(string $field): self
    {
        $this->field = $field;

        return $this;
    }

    public function getOldValue(): ChangeValue
    {
        return $this->oldValue;
    }

    /**
     * @return $this
     */
    public function setOldValue(ChangeValue $oldValue): self
    {
        $this->oldValue = $oldValue;

        return $this;
    }

    public function getNewValue(): ChangeValue
    {
        return $this->newValue;
    }

    /**
     * @return $this
     */
    public function setNewValue(ChangeValue $newValue): self
    {
        $this->newValue = $newValue;

        return $this;
    }

    /**
     * @return Event<mixed, mixed>
     */
    public function getEvent(): Event
    {
        return $this->event;
    }

    /**
     * @param Event<mixed, mixed> $event
     *
     * @return $this
     */
    public function setEvent(Event $event): self
    {
        $this->event = $event;

        return $this;
    }
}
