<?php

/**
 * This file is subject to the terms and conditions defined in file 'LICENSE', which is part of this source code
 * package. If the file is missing a copy can be found at:
 * https://gitlab.cybercoder.site/vj/policies-procedures-standards/blob/master/licensing/CYBER-LICENSE.
 */

namespace Cyber\AuditBundle\Repository;

use Cyber\AuditBundle\Entity\Criteria\EventCriteria;
use Cyber\AuditBundle\Entity\Event;
use Doctrine\ORM\EntityRepository;
use Doctrine\ORM\QueryBuilder;

/**
 * @extends EntityRepository<Event>
 *
 * @see Event
 */
class EventRepository extends EntityRepository
{
    public function match(EventCriteria $criteria): QueryBuilder
    {
        $queryBuilder = $this->createQueryBuilder('evt');

        $this->matchTypes($queryBuilder, $criteria);
        $this->matchDateFrom($queryBuilder, $criteria);
        $this->matchDateTo($queryBuilder, $criteria);

        return $queryBuilder;
    }

    private function matchTypes(QueryBuilder $queryBuilder, EventCriteria $criteria): void
    {
        if ([] === $criteria->actions) {
            return;
        }

        $queryBuilder->andWhere('evt.type in (:eventTypes)')->setParameter('eventTypes', $criteria->actions);
    }

    private function matchDateFrom(QueryBuilder $queryBuilder, EventCriteria $criteria): void
    {
        if (null === $criteria->dateFrom) {
            return;
        }

        $queryBuilder->andWhere('evt.dateCreated >= :dateFrom')->setParameter('dateFrom', $criteria->dateFrom);
    }

    private function matchDateTo(QueryBuilder $queryBuilder, EventCriteria $criteria): void
    {
        if (null === $criteria->dateTo) {
            return;
        }

        $queryBuilder->andWhere('evt.dateCreated < :dateTo')->setParameter('dateTo', $criteria->dateTo);
    }
}
