<?php

/**
 * This file is subject to the terms and conditions defined in file 'LICENSE', which is part of this source code
 * package. If the file is missing a copy can be found at:
 * https://gitlab.cybercoder.site/vj/policies-procedures-standards/blob/master/licensing/CYBER-LICENSE.
 */

namespace Cyber\AuditBundle\Attribute;

use Attribute;

/**
 * Use this attribute at the class level to specify which properties from parent classes
 * should be tracked or skipped for auditing.
 */
#[Attribute(Attribute::TARGET_CLASS)]
class ParentProps implements AuditAttribute
{
    /** @var string[] */
    public array $track = [];

    /** @var string[] */
    public array $skip = [];

    /**
     * @param string[] $track Properties from parent class to track
     * @param string[] $skip  Properties from parent class to skip
     */
    public function __construct(array $track = [], array $skip = [])
    {
        $this->track = $track;
        $this->skip  = $skip;
    }
}
