<?php

/**
 * This file is subject to the terms and conditions defined in file 'LICENSE', which is part of this source code
 * package. If the file is missing a copy can be found at:
 * https://gitlab.cybercoder.site/vj/policies-procedures-standards/blob/master/licensing/CYBER-LICENSE.
 */

namespace Symfony\Component\DependencyInjection\Loader\Configurator;

use Cyber\AuditBundle\AuditEvents;
use Cyber\AuditBundle\AuditMetadataFactory;
use Cyber\AuditBundle\EventListener\AuditDoctrineListener;
use Cyber\AuditBundle\EventListener\AuditKernelListener;
use Cyber\AuditBundle\Service\AttributeReader;
use Cyber\AuditBundle\Service\AuditManager;
use Cyber\AuditBundle\Service\AuditQueue;
use Cyber\AuditBundle\Service\ChangeHydrator;
use Cyber\AuditBundle\Service\ChangeValueTransformer;
use Cyber\AuditBundle\Service\EntityFactory;
use Symfony\Component\Console\ConsoleEvents;
use Symfony\Component\HttpKernel\KernelEvents;

return static function (ContainerConfigurator $container) {
    // @formatter:off
    $container->parameters()
        ->set('cyber_audit.entity.change', null)
        ->set('cyber_audit.entity.event', null)
        ->set('cyber_audit.entity.map', null)
        ->set('cyber_audit.entity_factory_class', EntityFactory::class);

    $container->services()

        ->set('cyber_audit.service.attribute_reader', AttributeReader::class)
        ->alias(AttributeReader::class, 'cyber_audit.service.attribute_reader')

        ->set('cyber_audit.service.audit_queue', AuditQueue::class)
        ->alias(AuditQueue::class, 'cyber_audit.service.audit_queue')

        ->set('cyber_audit.service.audit_metadata_factory', AuditMetadataFactory::class)
            ->args([
                service('cyber_audit.service.attribute_reader'),
                service('cache.cyber_audit.metadata')->nullOnInvalid(),
            ])
        ->alias(AuditMetadataFactory::class, 'cyber_audit.service.audit_metadata_factory')

        ->set('cyber_audit.service.entity_factory', '%cyber_audit.entity_factory_class%')
            ->args([
                param('cyber_audit.entity.change'),
                param('cyber_audit.entity.event'),
                param('cyber_audit.entity.map'),
            ])
        ->alias(EntityFactory::class, 'cyber_audit.service.entity_factory')

        ->set('cyber_audit.service.audit_manager', AuditManager::class)
            ->args([
                service('cyber_audit.service.entity_factory'),
                service('doctrine'),
                service('cyber_audit.service.audit_metadata_factory'),
                service('cyber_audit.service.audit_queue'),
            ])
        ->alias(AuditManager::class, 'cyber_audit.service.audit_manager')

        ->set('cyber_audit.service.change_value_transformer', ChangeValueTransformer::class)
            ->args([
                service('doctrine'),
                service('cyber_audit.service.audit_manager'),
            ])
        ->alias(ChangeValueTransformer::class, 'cyber_audit.service.change_value_transformer')

        ->set('cyber_audit.service.change_hydrator', ChangeHydrator::class)
            ->args([
                service('cyber_audit.service.change_value_transformer'),
            ])
        ->alias(ChangeHydrator::class, 'cyber_audit.service.change_hydrator')

        ->set('cyber_audit.event_listener.doctrine', AuditDoctrineListener::class)
            ->args([
                service('cyber_audit.service.change_hydrator'),
                service('cyber_audit.service.audit_manager'),
            ])
            ->tag('doctrine.event_listener', ['event' => 'onFlush'])
        ->alias(AuditDoctrineListener::class, 'cyber_audit.event_listener.doctrine')

        ->set('cyber_audit.event_listener.kernel', AuditKernelListener::class)
            ->args([
                service('doctrine'),
                service('cyber_audit.service.audit_queue'),
                service('cyber_audit.service.audit_manager'),
            ])
            ->call('setLogger', [
                service('logger')->nullOnInvalid(),
            ])
            ->tag('kernel.event_listener', ['event' => KernelEvents::TERMINATE, 'method' => 'storeAudits'])
            ->tag('kernel.event_listener', ['event' => ConsoleEvents::TERMINATE, 'method' => 'storeAudits'])
            ->tag('kernel.event_listener', ['event' => AuditEvents::FLUSH_QUEUE, 'method' => 'storeAudits'])
        ->alias(AuditKernelListener::class, 'cyber_audit.event_listener.kernel')

        ->set('cache.cyber_audit.metadata')
            ->parent('cache.system')
            ->tag('cache.pool');
    // @formatter:on
};
