<?php

/**
 * This file is subject to the terms and conditions defined in file 'LICENSE', which is part of this source code
 * package. If the file is missing a copy can be found at:
 * https://gitlab.cybercoder.site/vj/policies-procedures-standards/blob/master/licensing/CYBER-LICENSE.
 */

namespace Cyber\AuditBundle\Attribute;

use Attribute;

/**
 * If inclusion policy is 'NONE' you must apply this attribute to each field you wish to track.
 */
#[Attribute(Attribute::TARGET_PROPERTY)]
class Track implements AuditAttribute
{
    /**
     * If this property stores values that are non-user friendly constants/ids/statuses you may provide fully qualified
     * path to an array which contains user friendly descriptions of these values, in order to create a more user
     * friendly audit.
     *
     * Array must have keys matching the values stored in this field, and values of those keys will be used as user
     * friendly value.
     *
     * @var null|string|string[]
     */
    public $userValueList;

    /**
     * @param null|string|string[] $userValueList
     */
    public function __construct($userValueList = null)
    {
        $this->userValueList = $userValueList;
    }
}
