<?php

/**
 * This file is subject to the terms and conditions defined in file 'LICENSE', which is part of this source code
 * package. If the file is missing a copy can be found at:
 * https://gitlab.cybercoder.site/vj/policies-procedures-standards/blob/master/licensing/CYBER-LICENSE.
 */

namespace Tests\Cyber\AuditBundle\Mock;

use Cyber\AuditBundle\Attribute\Apply;
use Cyber\AuditBundle\Attribute\ParentProps;
use Cyber\AuditBundle\Attribute\Track;

/**
 * Mock class that extends MockUser to test the ParentProps attribute with NONE inclusion policy.
 */
#[Apply(inclusionCriteria: 'NONE')]
#[ParentProps(track: ['name'])]
class MockExtendedUserNone extends MockUser
{
    /** @var string */
    #[Track]
    private $role;

    /**
     * @return string
     */
    public function getRole()
    {
        return $this->role;
    }

    /**
     * @param string $role
     *
     * @return MockExtendedUserNone
     */
    public function setRole($role): self
    {
        $this->role = $role;

        return $this;
    }
}
