<?php

/**
 * This file is subject to the terms and conditions defined in file 'LICENSE', which is part of this source code
 * package. If the file is missing a copy can be found at:
 * https://gitlab.cybercoder.site/vj/policies-procedures-standards/blob/master/licensing/CYBER-LICENSE.
 */

namespace Symfony\Component\DependencyInjection\Loader\Configurator;

use Cyber\AuditBundle\AuditMetadataFactory;

return static function (ContainerConfigurator $container) {
    // @formatter:off
    $container->services()
        // In debug mode, don't use cache for AuditMetadataFactory
        ->set('cyber_audit.service.audit_metadata_factory', AuditMetadataFactory::class)
            ->args([
                service('cyber_audit.service.attribute_reader'),
                null, // No cache in debug mode
            ]);
    // @formatter:on
};
