<?php

/**
 * This file is subject to the terms and conditions defined in file 'LICENSE', which is part of this source code
 * package. If the file is missing a copy can be found at:
 * https://gitlab.cybercoder.site/vj/policies-procedures-standards/blob/master/licensing/CYBER-LICENSE.
 */

namespace Tests\Cyber\AuditBundle\Attribute;

use Cyber\AuditBundle\AuditMetadata;
use Cyber\AuditBundle\AuditMetadataFactory;
use Cyber\AuditBundle\Service\AttributeReader;
use Doctrine\ORM\Mapping\ClassMetadata;
use PHPUnit\Framework\TestCase;
use ReflectionClass;
use Tests\Cyber\AuditBundle\Mock\MockExtendedUser;
use Tests\Cyber\AuditBundle\Mock\MockExtendedUserNone;

/**
 * @internal
 *
 * @covers \Cyber\AuditBundle\Attribute\ParentProps
 * @covers \Cyber\AuditBundle\Attribute\AuditMetadataFactory
 */
class ParentPropsTest extends TestCase
{
    private AuditMetadataFactory $factory;

    private ClassMetadata $metadata;

    protected function setUp(): void
    {
        $this->factory = new AuditMetadataFactory(new AttributeReader());

        // Create a mock ClassMetadata
        $this->metadata = $this->createMock(ClassMetadata::class);
        $this->metadata->method('getReflectionClass')
            ->willReturn(new ReflectionClass(MockExtendedUser::class));
        $this->metadata->method('getName')
            ->willReturn(MockExtendedUser::class);
        $this->metadata->embeddedClasses = [];
    }

    public function testParentPropsAttribute(): void
    {
        // Get the audit metadata for MockExtendedUser
        $auditMetadata = $this->factory->getAuditMetadata($this->metadata);

        static::assertInstanceOf(AuditMetadata::class, $auditMetadata);

        $properties = $auditMetadata->getProperties();

        static::assertTrue($properties->contains('name'), 'The name property from the parent class should be tracked');
        static::assertFalse($properties->contains('id'), 'The id property from the parent class should not be tracked');
        static::assertTrue($properties->contains('role'), 'The role property from the child class should be tracked');
    }

    public function testParentPropsWithNoneInclusionPolicy(): void
    {
        // Create a mock ClassMetadata for MockExtendedUserNone
        $metadataNone = $this->createMock(ClassMetadata::class);
        $metadataNone->method('getReflectionClass')
            ->willReturn(new ReflectionClass(MockExtendedUserNone::class));
        $metadataNone->method('getName')
            ->willReturn(MockExtendedUserNone::class);
        $metadataNone->embeddedClasses = [];

        // Get the audit metadata
        $auditMetadata = $this->factory->getAuditMetadata($metadataNone);

        static::assertInstanceOf(AuditMetadata::class, $auditMetadata);

        $properties = $auditMetadata->getProperties();

        static::assertTrue($properties->contains('name'), 'The name property from the parent class should be tracked');
        static::assertFalse($properties->contains('id'), 'The id property from the parent class should not be tracked');
        static::assertTrue($properties->contains('role'), 'The role property from the child class should be tracked');
    }
}
