<?php

/**
 * This file is subject to the terms and conditions defined in file 'LICENSE', which is part of this source code
 * package. If the file is missing a copy can be found at:
 * https://gitlab.cybercoder.site/vj/policies-procedures-standards/blob/master/licensing/CYBER-LICENSE.
 */

namespace Tests\Cyber\AuditBundle;

use Cyber\AuditBundle\AuditBuilder;
use Cyber\AuditBundle\AuditEventMapper;
use Cyber\AuditBundle\Service\AuditManager;
use Doctrine\ORM\EntityManagerInterface;
use Doctrine\ORM\Mapping\ClassMetadata;
use PHPUnit\Framework\Constraint\IsInstanceOf;
use PHPUnit\Framework\MockObject\MockObject;
use PHPUnit\Framework\TestCase;
use ReflectionClass;
use stdClass;

/**
 * @internal
 *
 * @covers \Cyber\AuditBundle\AuditEventMapper
 */
class AuditEventMapperTest extends TestCase
{
    /** @var AuditEventMapper */
    private $eventMapper;

    /** @var AuditBuilder<mixed, mixed>|MockObject */
    private $builder;

    /** @var EntityManagerInterface|MockObject */
    private $em;

    /** @var AuditManager<mixed, mixed>|MockObject */
    private $auditManager;

    /**
     * @inheritDoc
     */
    protected function setUp(): void
    {
        $this->builder      = $this->getMockBuilder(AuditBuilder::class)->disableOriginalConstructor()->getMock();
        $this->em           = $this->getMockBuilder(EntityManagerInterface::class)->getMock();
        $this->auditManager = $this->getMockBuilder(AuditManager::class)->disableOriginalConstructor()->getMock();

        $this->eventMapper = new AuditEventMapper($this->em, $this->auditManager);
    }

    public function testMapSelf(): void
    {
        $stdMetadata = $this->getMockBuilder(ClassMetadata::class)->disableOriginalConstructor()->getMock();
        $ownerMeta   = $this->getMockBuilder(ClassMetadata::class)->disableOriginalConstructor()->getMock();

        $this->em->expects(static::any())
            ->method('getClassMetadata')
            ->willReturnCallback(function ($classname) use ($stdMetadata, $ownerMeta) {
                switch ($classname) {
                    case 'stdClass':
                        return $stdMetadata;
                    case '':
                        return $ownerMeta;
                }
            });

        $stdMetadata->expects(static::any())
            ->method('getReflectionClass')
            ->willReturn(new ReflectionClass('stdClass'));

        $this->builder->expects(static::once())
            ->method('mappedTo')
            ->with('stdClass', new IsInstanceOf('Closure'));
        $this->eventMapper->buildEventMap($this->builder, new stdClass());
    }
}
