<?php

/**
 * This file is subject to the terms and conditions defined in file 'LICENSE', which is part of this source code
 * package. If the file is missing a copy can be found at:
 * https://gitlab.cybercoder.site/vj/policies-procedures-standards/blob/master/licensing/CYBER-LICENSE.
 */

declare(strict_types=1);

namespace Tests\Cyber\AuditBundle\Service;

use Cyber\AuditBundle\Annotation\Apply;
use Cyber\AuditBundle\Annotation\Describe;
use Cyber\AuditBundle\Service\AttributeReader;
use PHPUnit\Framework\TestCase;
use ReflectionClass;

/**
 * @internal
 *
 * @covers \Cyber\AuditBundle\Service\AttributeReader
 */
#[Apply(inclusionCriteria: 'NONE', displayName: 'test')]
class AttributeReaderTest extends TestCase
{
    #[Describe]
    public function testReader(): void
    {
        if (PHP_VERSION_ID < 80000) {
            static::markTestSkipped('Only PHP >= 8');
        }
        $instance = new AttributeReader();

        $ref = new ReflectionClass(self::class);

        /** @var null|Apply $apply */
        $apply = $instance->getClassAttribute($ref, Apply::class);

        static::assertNotNull($apply);
        static::assertEquals('NONE', $apply->inclusionCriteria);
        static::assertEquals('test', $apply->displayName);

        $describe = $instance->getMethodAttribute($ref->getMethod('testReader'), Describe::class);
        static::assertInstanceOf(Describe::class, $describe);
    }
}
