<?php
/**
 * This file is subject to the terms and conditions defined in file 'LICENSE', which is part of this source code
 * package. If the file is missing a copy can be found at:
 * https://gitlab.cybercoder.site/vj/policies-procedures-standards/blob/master/licensing/CYBER-LICENSE.
 */

namespace Tests\Cyber\CacheBundle\Mock;

class MockMemcache extends \Memcache
{
    /** @var array<mixed> */
    private $data = [];

    /** @var bool */
    private $failAdd = false;

    public function testsSetFailAdd(bool $enable): void
    {
        $this->failAdd = $enable;
    }

    /**
     * {@inheritdoc}
     */
    public function add($key, $var, $flag, $expire): bool
    {
        if ($this->failAdd || isset($this->data[$key])) {
            return false;
        }

        $this->data[$key] = $var;

        return true;
    }

    /**
     * {@inheritdoc}
     */
    public function set($key, $var, $flag, $expire): bool
    {
        $this->data[$key] = $var;

        return true;
    }

    /**
     * {@inheritdoc}
     */
    public function get($key, &$flags, &$extra = null)
    {
        if (!isset($this->data[$key])) {
            return false;
        }

        return $this->data[$key];
    }

    /**
     * {@inheritdoc}
     */
    public function delete($key, $timeout = 0): bool
    {
        unset($this->data[$key]);

        return true;
    }

    /**
     * {@inheritdoc}
     */
    public function increment($key, $value = 1)
    {
        if (!isset($this->data[$key])) {
            return false;
        }

        return ++$this->data[$key];
    }

    /**
     * {@inheritdoc}
     */
    public function decrement($key, $value = 1)
    {
        if (!isset($this->data[$key])) {
            return false;
        }

        return --$this->data[$key];
    }
}
