<?php
/**
 * This file is subject to the terms and conditions defined in file 'LICENSE', which is part of this source code
 * package. If the file is missing a copy can be found at:
 * https://gitlab.cybercoder.site/vj/policies-procedures-standards/blob/master/licensing/CYBER-LICENSE.
 */

namespace Cyber\CacheBundle\Engine;

class EngineFactory
{
    /** @var CacheInterface */
    private $engine;

    /** @var string */
    private $engineClass;

    /**
     * @param CacheInterface $engine
     */
    public function __construct(CacheInterface $engine)
    {
        $this->engine      = $engine;
        $this->engineClass = \get_class($engine);
    }

    /**
     * Creates a CacheInterface instance with prefix being a combination of globalPrefix and prefix from argument.
     *
     * @param string $prefix
     *
     * @return CacheInterface
     */
    public function create(string $prefix): CacheInterface
    {
        return new $this->engineClass($this->engine, $prefix);
    }

    /**
     * @return CacheInterface
     */
    public function getEngine(): CacheInterface
    {
        return $this->engine;
    }

    /**
     * @return string
     */
    public function getGlobalPrefix(): string
    {
        return $this->engine->getPrefix();
    }
}
