<?php
/**
 * This file is subject to the terms and conditions defined in file 'LICENSE', which is part of this source code
 * package. If the file is missing a copy can be found at:
 * https://gitlab.cybercoder.site/vj/policies-procedures-standards/blob/master/licensing/CYBER-LICENSE.
 */

namespace Cyber\CacheBundle\Engine;

trait EngineTrait
{
    /** @var CacheInterface|mixed */
    protected $engine;

    /** @var string */
    protected $prefix;

    public function getPrefix(): string
    {
        return $this->prefix;
    }

    public function getFullPrefix(): string
    {
        /** @var string $prefix */
        $prefix = $this->addPrefix('');
        if ($this->engine instanceof CacheInterface) {
            $prefix = (string) $this->engine->addPrefix($prefix);
        }

        return $prefix;
    }

    /**
     * @param null|string|string[] $key
     *
     * @return null|string|string[]
     */
    public function addPrefix($key)
    {
        if (null === $key) {
            return null;
        }

        if (!\is_array($key)) {
            return $this->prefix . '_' . $key;
        }

        return \array_map(function ($key) {
            return $this->prefix . '_' . $key;
        }, $key);
    }
}
