Installation
============

Step 1: Download the Bundle
---------------------------

Open a command console, enter your project directory and execute the
following command to download the latest stable version of this bundle:

```console
$ composer require cyber/cache-bundle
```

This command requires you to have Composer installed globally, as explained
in the [installation chapter](https://getcomposer.org/doc/00-intro.md)
of the Composer documentation.

> This bundle is part of `cyber/symfony-collection`, so if you have that included in your composer you already have it

Step 2: Enable the Bundle
-------------------------

Then, enable the bundle by adding it to the list of registered bundles
in the `app/AppKernel.php` file of your project:

```php
<?php
// app/AppKernel.php

// ...
class AppKernel extends Kernel
{
    public function registerBundles(): void
    {
        $bundles = array(
            // ...

            new Cyber\CacheBundle\CyberCacheBundle(),
        );

        // ...
    }

    // ...
}
```

Step 3: Configuring and using the Bundle
----------------------------------------

Review the [Full Documentation](./src/Resources/doc/index.md) for all details on configuration and 
usage of **CyberCacheBundle**.
