<?php
/**
 * This file is subject to the terms and conditions defined in file 'LICENSE', which is part of this source code
 * package. If the file is missing a copy can be found at:
 * https://gitlab.cybercoder.site/vj/policies-procedures-standards/blob/master/licensing/CYBER-LICENSE.
 */

namespace Cyber\CacheBundle\DependencyInjection;

use Symfony\Component\Config\Definition\Builder\ArrayNodeDefinition;
use Symfony\Component\Config\Definition\Builder\TreeBuilder;
use Symfony\Component\Config\Definition\ConfigurationInterface;

/**
 * This is the class that validates and merges configuration from your app/config files.
 *
 * To learn more see {@link http://symfony.com/doc/current/cookbook/bundles/extension.html#cookbook-bundles-extension-config-class}
 */
class Configuration implements ConfigurationInterface
{
    /**
     * {@inheritdoc}
     */
    public function getConfigTreeBuilder(): TreeBuilder
    {
        $treeBuilder = new TreeBuilder('cyber_cache');

        /** @var ArrayNodeDefinition $rootNode */
        $rootNode = $treeBuilder->getRootNode();

        //@formatter:off
        $rootNode
            ->children()
                ->enumNode('engine')
                    ->values(['memcache', 'redis'])
                    ->defaultValue('memcache')
                    ->info('Select which engine to use for storage.')
                ->end()
                ->scalarNode('host')->isRequired()->cannotBeEmpty()->end()
                ->scalarNode('port')->end()
                ->scalarNode('prefix')
                    ->info('Global prefix')
                    ->isRequired()
                    ->cannotBeEmpty()
                ->end()
                ->arrayNode('sub_prefixes')->info('Array of prefixes. A service will be generated for each element in this array to access the particular prefix.')
                    ->prototype('scalar')
                ->end()
            ->end();
        //@formatter:on
        return $treeBuilder;
    }
}
