<?php
/**
 * This file is subject to the terms and conditions defined in file 'LICENSE', which is part of this source code
 * package. If the file is missing a copy can be found at:
 * https://gitlab.cybercoder.site/vj/policies-procedures-standards/blob/master/licensing/CYBER-LICENSE.
 */

namespace Tests\Cyber\CacheBundle\Engine;

use Cyber\CacheBundle\Engine\EngineFactory;
use Cyber\CacheBundle\Engine\Memcache\PrefixedMemcache;
use PHPUnit\Framework\TestCase;

class EngineFactoryTest extends TestCase
{
    public function testCreate(): void
    {
        $prefix   = 'global';
        $memcache = $this->mockMemcache();

        $globalMemcached = new PrefixedMemcache($memcache, $prefix);
        $factory         = new EngineFactory($globalMemcached);

        $memcache = $factory->create('local');

        $localPrefix = $memcache->getFullPrefix();

        $this->assertEquals('global_local_', $localPrefix);
    }

    public function testGetPrefix(): void
    {
        $prefix   = 'global';
        $memcache = $this->mockMemcache();

        $globalMemcached = new PrefixedMemcache($memcache, $prefix);
        $factory         = new EngineFactory($globalMemcached);

        $result = $factory->getGlobalPrefix();

        $this->assertEquals($prefix, $result);
    }

    /**
     * @return \PHPUnit_Framework_MockObject_MockObject&\Memcache
     */
    private function mockMemcache()
    {
        return $this->getMockBuilder(\Memcache::class)
            ->disableOriginalConstructor()
            ->getMock();
    }
}
