<?php
/**
 * This file is subject to the terms and conditions defined in file 'LICENSE', which is part of this source code
 * package. If the file is missing a copy can be found at:
 * https://gitlab.cybercoder.site/vj/policies-procedures-standards/blob/master/licensing/CYBER-LICENSE.
 */

namespace Cyber\CronBundle\Component;

/**
 * Interface CronTask.
 */
interface CronTaskInterface
{
    /**
     * If your task returns FALSE or throw any exception it will be disable from future executions. It can be re-enabled
     * by clearing the corresponding flag in the CronTaskInfo entity.
     *
     * @throws \Exception if any error occurs
     *
     * @return bool FALSE on critical failure
     */
    public function execute(): ?bool;

    /**
     * The name of the schedule this task should follow.
     *
     * Valid values are 'hourly', 'daily' or any custom schedule you have defined in the config
     *
     * @return string
     */
    public function getSchedule(): string;
}
