<?php
/**
 * This file is subject to the terms and conditions defined in file 'LICENSE', which is part of this source code
 * package. If the file is missing a copy can be found at:
 * https://gitlab.cybercoder.site/vj/policies-procedures-standards/blob/master/licensing/CYBER-LICENSE.
 */

namespace Cyber\CronBundle\Entity;

use Doctrine\ORM\Mapping as ORM;
use Doctrine\ORM\Mapping\MappedSuperclass;

/**
 * CronTaskInfo.
 *
 * @MappedSuperclass
 * @SuppressWarnings(PHPMD.BooleanGetMethodName)
 */
class CronTaskInfo
{
    /**
     * @var string
     *
     * @ORM\Column(type="string", length=100, unique=true)
     */
    protected $serviceId;

    /**
     * @var \DateTime
     *
     * @ORM\Column(type="datetime")
     */
    protected $lastRun;

    /**
     * @var bool
     *
     * @ORM\Column(type="boolean", options={"default": false})
     */
    protected $isRunning = false;

    /**
     * @var bool
     *
     * @ORM\Column(type="boolean", options={"default": false})
     */
    protected $isDisabled = false;

    /**
     * Set serviceId.
     *
     * @param string $serviceId
     *
     * @return CronTaskInfo
     */
    public function setServiceId($serviceId): self
    {
        $this->serviceId = $serviceId;

        return $this;
    }

    /**
     * Get serviceId.
     *
     * @return string
     */
    public function getServiceId(): string
    {
        return $this->serviceId;
    }

    /**
     * Set lastRun.
     *
     * @param \DateTime $lastRun
     *
     * @return CronTaskInfo
     */
    public function setLastRun($lastRun): self
    {
        $this->lastRun = $lastRun;

        return $this;
    }

    /**
     * Get lastRun.
     *
     * @return \DateTime
     */
    public function getLastRun(): \DateTime
    {
        return $this->lastRun;
    }

    /**
     * Set isRunning.
     *
     * @param bool $isRunning
     *
     * @return CronTaskInfo
     */
    public function setIsRunning($isRunning): self
    {
        $this->isRunning = $isRunning;

        return $this;
    }

    /**
     * Get isRunning.
     *
     * @return bool
     */
    public function getIsRunning(): bool
    {
        return $this->isRunning;
    }

    /**
     * Set isDisabled.
     *
     * @param bool $isDisabled
     *
     * @return CronTaskInfo
     */
    public function setIsDisabled($isDisabled): self
    {
        $this->isDisabled = $isDisabled;

        return $this;
    }

    /**
     * Get isDisabled.
     *
     * @return bool
     */
    public function getIsDisabled(): bool
    {
        return $this->isDisabled;
    }
}
