<?php
/**
 * This file is subject to the terms and conditions defined in file 'LICENSE', which is part of this source code
 * package. If the file is missing a copy can be found at:
 * https://gitlab.cybercoder.site/vj/policies-procedures-standards/blob/master/licensing/CYBER-LICENSE.
 */

namespace Cyber\CronBundle\Event;

use Cyber\CronBundle\Entity\CronTaskInfo;
use Symfony\Contracts\EventDispatcher\Event;

/**
 * Class CronTaskInfoEvent.
 */
class CronTaskInfoEvent extends Event
{
    /**
     * @var CronTaskInfo
     */
    private $taskInfo;

    /**
     * CronTaskInfoEvent constructor.
     *
     * @param CronTaskInfo $taskInfo
     */
    public function __construct(CronTaskInfo $taskInfo)
    {
        $this->taskInfo = $taskInfo;
    }

    /**
     * @return CronTaskInfo
     */
    public function getTaskInfo(): CronTaskInfo
    {
        return $this->taskInfo;
    }
}
