<?php
/**
 * This file is subject to the terms and conditions defined in file 'LICENSE', which is part of this source code
 * package. If the file is missing a copy can be found at:
 * https://gitlab.cybercoder.site/vj/policies-procedures-standards/blob/master/licensing/CYBER-LICENSE.
 */

namespace Cyber\CronBundle\DependencyInjection\Compiler;

use Symfony\Component\Config\Definition\Exception\InvalidConfigurationException;
use Symfony\Component\DependencyInjection\Argument\ServiceClosureArgument;
use Symfony\Component\DependencyInjection\Compiler\CompilerPassInterface;
use Symfony\Component\DependencyInjection\ContainerBuilder;
use Symfony\Component\DependencyInjection\Reference;

class HandlersPass implements CompilerPassInterface
{
    /**
     * @param ContainerBuilder $container
     *
     * @throws \Symfony\Component\DependencyInjection\Exception\ServiceNotFoundException
     * @throws \Symfony\Component\DependencyInjection\Exception\InvalidArgumentException
     * @throws \Symfony\Component\Config\Definition\Exception\InvalidConfigurationException
     * @SuppressWarnings(PHPMD.LongVariable)
     */
    public function process(ContainerBuilder $container): void
    {
        $cronManagerDefinition = $container->findDefinition('Cyber\CronBundle\Manager\CronManager');
        $dailyHandlers         = $container->findTaggedServiceIds('cyber.cron.daily');
        if (!empty($dailyHandlers)) {
            throw new InvalidConfigurationException(\sprintf(
                'Using tag "cyber.cron.daily" is no longer supported, please update the following services [%s]',
                \implode(',', \array_keys($dailyHandlers))
            ));
        }
        $hourlyHandlers = $container->findTaggedServiceIds('cyber.cron.hourly');
        if (!empty($hourlyHandlers)) {
            throw new InvalidConfigurationException(\sprintf(
                'Using tag "cyber.cron.hourly" is no longer supported, please update the following services [%s]',
                \implode(',', \array_keys($hourlyHandlers))
            ));
        }

        $cronHandlers = $container->findTaggedServiceIds('cyber.cron');

        foreach ($cronHandlers as $service => $tags) {
            foreach ($tags as $tag) {
                if (isset($tag['schedule'])) {
                    throw new InvalidConfigurationException('"schedule" parameter no longer supported on cyber.cron tags');
                }
            }

            $cronManagerDefinition->addMethodCall('addScheduledTaskClosure', [new ServiceClosureArgument(new Reference($service))]);
        }
    }
}
