<?php
/**
 * This file is subject to the terms and conditions defined in file 'LICENSE', which is part of this source code
 * package. If the file is missing a copy can be found at:
 * https://gitlab.cybercoder.site/vj/policies-procedures-standards/blob/master/licensing/CYBER-LICENSE.
 */

namespace Cyber\CronBundle\Event;

use Cyber\CronBundle\Component\CronTaskInterface;
use Cyber\CronBundle\Entity\CronTaskInfo;
use Cyber\CronBundle\Manager\ScheduleContext;
use Symfony\Contracts\EventDispatcher\Event;

abstract class TaskEvent extends Event
{
    /**
     * @var ScheduleContext
     */
    protected $context;

    public function __construct(ScheduleContext $context)
    {
        $this->context = $context;
    }

    public function toTask(): CronTaskInterface
    {
        return $this->context->getTask();
    }

    public function toMetadata(): CronTaskInfo
    {
        return $this->context->getMeta();
    }

    public function toContext(): ScheduleContext
    {
        return $this->context;
    }
}
